# -*- coding: utf-8 -*-

"""
Module implementing MainWindow.
"""

from PyQt5.QtCore import pyqtSlot,  QUrl
from PyQt5.QtWidgets import QMainWindow

from .Ui_mainwindow import Ui_MainWindow


class MainWindow(QMainWindow, Ui_MainWindow):
    """
    Class documentation goes here.
    """
    def __init__(self, parent=None):
        """
        Constructor
        
        @param parent reference to the parent widget
        @type QWidget
        """
        super(MainWindow, self).__init__(parent)
        self.setupUi(self)
    
    @pyqtSlot()
    def on_btnNavigate_released(self):
        """
        Slot documentation goes here.
        """
        # TODO: check out this code, ensure it covers all the possibilities
        theUrl = self.txtUrl.text();
        if theUrl[0:7]!='http://':
            theUrl = 'http://'+theUrl
        self.webEngineView.setUrl(QUrl(theUrl))            
    
    @pyqtSlot(str)
    def on_webEngineView_titleChanged(self, title):
        """
        Slot documentation goes here.
        
        @param title DESCRIPTION
        @type str
        """
        self.setWindowTitle(title)
    
    @pyqtSlot(QUrl)
    def on_webEngineView_urlChanged(self, p0):
        """
        Slot documentation goes here.
        
        @param p0 DESCRIPTION
        @type QUrl
        """
        self.txtUrl.setText(p0.toString())
